/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWReceiveParamPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class VWReceiveGeneralPanel
extends JPanel {
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_VALUE = 2;
    private VWReceiveParamPanel m_parent = null;
    private DefaultTableCellRenderer m_tableCellRenderer = null;
    private VWInstructionDefinition m_instructionDef = null;
    private JTextField m_partnerLink = null;
    private JTextField m_operation = null;
    private JTextField m_messageType = null;
    private JPanel m_basicPanel = null;
    private JPanel m_advancedPanel = null;
    private VWWebServiceParameterDefinition[] m_receiveParams = null;
    private String[] m_receiveParamsTableColumnNames = new String[]{VWResource.s_name, VWResource.s_type, VWResource.s_fieldName};
    private VWTable m_receiveParamsTable = null;
    private AbstractTableModel m_receiveParamsTableModel = null;
    private JTextField m_receiveIncomingXMLDataField = null;
    private JTextField m_receiveSchema = null;
    private JTextField m_receiveElement = null;

    public VWReceiveGeneralPanel(VWReceiveParamPanel parent, DefaultTableCellRenderer tableCellRenderer, VWInstructionDefinition instruction) {
        this.m_parent = parent;
        this.m_tableCellRenderer = tableCellRenderer;
        this.m_instructionDef = instruction;
        this.setupLayout();
    }

    public void setInstructionDefinition(VWReceiveInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.reinitialize();
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        int mode = this.m_parent.getReceiveMessageType();
        JLabel partnerLinkLabel = new JLabel(VWResource.s_partnerLink);
        this.m_partnerLink = new JTextField();
        this.m_partnerLink.setEditable(false);
        this.m_partnerLink.setBorder(null);
        JPanel partnerLinkPanel = new JPanel(new BorderLayout(10, 0));
        partnerLinkPanel.add((Component)partnerLinkLabel, "Before");
        partnerLinkPanel.add((Component)this.m_partnerLink, "Center");
        JLabel operationLabel = new JLabel(VWResource.s_operationColon);
        this.m_operation = new JTextField();
        this.m_operation.setEditable(false);
        this.m_operation.setBorder(null);
        JPanel operationPanel = new JPanel(new BorderLayout(10, 0));
        operationPanel.add((Component)operationLabel, "Before");
        operationPanel.add((Component)this.m_operation, "Center");
        JLabel modeLabel = new JLabel(VWResource.s_messageType);
        this.m_messageType = new JTextField();
        this.m_messageType.setEditable(false);
        this.m_messageType.setBorder(null);
        JPanel messageTypePanel = new JPanel(new BorderLayout(10, 0));
        messageTypePanel.add((Component)modeLabel, "Before");
        messageTypePanel.add((Component)this.m_messageType, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)partnerLinkPanel, c);
        c.gridy = -1;
        this.add((Component)operationPanel, c);
        c.gridy = -1;
        this.add((Component)messageTypePanel, c);
        this.m_basicPanel = this.createBasicPanel();
        this.m_advancedPanel = this.createAdvancedPanel();
        c.fill = 1;
        c.weighty = 1.0;
        this.add((Component)this.m_basicPanel, c);
        this.add((Component)this.m_advancedPanel, c);
        this.m_advancedPanel.setVisible(false);
        this.m_basicPanel.setVisible(false);
    }

    private JPanel createBasicPanel() {
        VWToolbarBorder paramsBorder = new VWToolbarBorder(VWResource.s_operationParameters, 0);
        JPanel paramsPanel = paramsBorder.getClientPanel();
        paramsPanel.setLayout(new BorderLayout());
        paramsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_receiveParamsTable = new VWTable();
        this.m_receiveParamsTable.setRowSelectionAllowed(true);
        this.m_receiveParamsTable.setColumnSelectionAllowed(false);
        this.m_receiveParamsTable.setSelectionMode(0);
        paramsPanel.add((Component)new JScrollPane(this.m_receiveParamsTable), "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 1;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)paramsBorder, c);
        return panel;
    }

    private JPanel createAdvancedPanel() {
        JLabel incomingXMLDataFieldLabel = new JLabel(VWResource.s_incomingXMLDataField);
        this.m_receiveIncomingXMLDataField = new JTextField();
        this.m_receiveIncomingXMLDataField.setEditable(false);
        this.m_receiveIncomingXMLDataField.setBorder(null);
        JPanel XMLDataFieldPanel = new JPanel(new BorderLayout(10, 0));
        XMLDataFieldPanel.add((Component)incomingXMLDataFieldLabel, "Before");
        XMLDataFieldPanel.add((Component)this.m_receiveIncomingXMLDataField, "Center");
        JLabel schemaLabel = new JLabel(VWResource.s_schema);
        this.m_receiveSchema = new JTextField();
        this.m_receiveSchema.setEditable(false);
        this.m_receiveSchema.setBorder(null);
        JPanel schemaPanel = new JPanel(new BorderLayout(10, 0));
        schemaPanel.add((Component)schemaLabel, "Before");
        schemaPanel.add((Component)this.m_receiveSchema, "Center");
        JLabel elementLabel = new JLabel(VWResource.s_element);
        this.m_receiveElement = new JTextField();
        this.m_receiveElement.setEditable(false);
        this.m_receiveElement.setBorder(null);
        JPanel elementPanel = new JPanel(new BorderLayout(10, 0));
        elementPanel.add((Component)elementLabel, "Before");
        elementPanel.add((Component)this.m_receiveElement, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        c.gridy = -1;
        panel.add((Component)XMLDataFieldPanel, c);
        panel.add((Component)schemaPanel, c);
        c.weighty = 1.0;
        panel.add((Component)elementPanel, c);
        return panel;
    }

    private void reinitialize() {
        try {
            int i;
            this.m_receiveParamsTableModel = null;
            this.m_advancedPanel.setVisible(false);
            this.m_basicPanel.setVisible(false);
            String partnerLink = ((VWReceiveInstruction)this.m_instructionDef).getPartnerLinkName();
            this.m_parent.setTextField(this.m_partnerLink, partnerLink);
            String operation = ((VWReceiveInstruction)this.m_instructionDef).getOperationName();
            this.m_parent.setTextField(this.m_operation, operation);
            if (this.m_parent.getReceiveMessageType() == 1) {
                this.m_parent.setTextField(this.m_messageType, VWResource.s_xml);
                this.m_advancedPanel.setVisible(true);
            } else {
                this.m_parent.setTextField(this.m_messageType, VWResource.s_parameters);
                this.m_basicPanel.setVisible(true);
            }
            String incomingXMLDataField = ((VWReceiveInstruction)this.m_instructionDef).getMessageExpr();
            this.m_parent.setTextField(this.m_receiveIncomingXMLDataField, incomingXMLDataField);
            String elementMsg = ((VWReceiveInstruction)this.m_instructionDef).getMessageFromElementName();
            this.m_parent.setTextField(this.m_receiveElement, elementMsg);
            String schemaMsg = ((VWReceiveInstruction)this.m_instructionDef).getMessageFromSchemaName();
            this.m_parent.setTextField(this.m_receiveSchema, schemaMsg);
            VWWebServiceParameterDefinition[] paramDefs = ((VWReceiveInstruction)this.m_instructionDef).getParameterDefinitions();
            Vector<VWWebServiceParameterDefinition> rows = new Vector<VWWebServiceParameterDefinition>();
            if (paramDefs != null) {
                for (i = 0; i < paramDefs.length; ++i) {
                    if (i < paramDefs.length - 1 && paramDefs[i].getLexicalLevel() < paramDefs[i + 1].getLexicalLevel()) continue;
                    rows.addElement(paramDefs[i]);
                }
            }
            this.m_receiveParams = new VWWebServiceParameterDefinition[rows.size()];
            for (i = 0; i < rows.size(); ++i) {
                VWWebServiceParameterDefinition paramItem = (VWWebServiceParameterDefinition)rows.elementAt(i);
                if (paramItem == null) continue;
                this.m_receiveParams[i] = paramItem;
            }
            if (this.m_receiveParams != null) {
                if (this.m_receiveParamsTableModel == null) {
                    this.m_receiveParamsTableModel = new AbstractTableModel(){

                        public boolean isCellEditable(int row, int col) {
                            return false;
                        }

                        public String getColumnName(int nColumnIndex) {
                            switch (nColumnIndex) {
                                case 0: {
                                    return VWReceiveGeneralPanel.this.m_receiveParamsTableColumnNames[0];
                                }
                                case 1: {
                                    return VWReceiveGeneralPanel.this.m_receiveParamsTableColumnNames[1];
                                }
                                case 2: {
                                    return VWReceiveGeneralPanel.this.m_receiveParamsTableColumnNames[2];
                                }
                            }
                            return null;
                        }

                        public int getColumnCount() {
                            return VWReceiveGeneralPanel.this.m_receiveParamsTableColumnNames.length;
                        }

                        public int getRowCount() {
                            if (VWReceiveGeneralPanel.this.m_receiveParams != null) {
                                return VWReceiveGeneralPanel.this.m_receiveParams.length;
                            }
                            return 0;
                        }

                        public Object getValueAt(int nRowIndex, int nColumnIndex) {
                            try {
                                if (VWReceiveGeneralPanel.this.m_receiveParams != null && nRowIndex >= 0 && nRowIndex < VWReceiveGeneralPanel.this.m_receiveParams.length) {
                                    VWWebServiceParameterDefinition paramDef = VWReceiveGeneralPanel.this.m_receiveParams[nRowIndex];
                                    if (paramDef == null) {
                                        return null;
                                    }
                                    switch (nColumnIndex) {
                                        case 0: {
                                            return paramDef.getName();
                                        }
                                        case 1: {
                                            return VWReceiveGeneralPanel.this.m_parent.getTypeFromParam(paramDef);
                                        }
                                        case 2: {
                                            return paramDef.getValue();
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                            }
                            return null;
                        }
                    };
                    this.m_receiveParamsTable.setModel(this.m_receiveParamsTableModel);
                }
                this.m_parent.setupTableCellRenderer(this.m_receiveParamsTable, this.m_receiveParamsTableModel);
                this.m_receiveParamsTableModel.fireTableDataChanged();
                this.m_receiveParamsTable.fitColumnsInTable();
                this.m_receiveParamsTable.updateUI();
            }
            this.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        int i;
        if (this.m_receiveParams != null) {
            for (i = 0; i < this.m_receiveParams.length; ++i) {
                this.m_receiveParams[i] = null;
            }
        }
        this.m_partnerLink = null;
        this.m_operation = null;
        this.m_messageType = null;
        this.m_receiveSchema = null;
        this.m_receiveElement = null;
        this.m_receiveIncomingXMLDataField = null;
        this.m_basicPanel = null;
        this.m_advancedPanel = null;
        for (i = 0; i < this.m_receiveParamsTableColumnNames.length; ++i) {
            this.m_receiveParamsTableColumnNames[i] = null;
        }
        if (this.m_receiveParamsTable != null) {
            this.m_receiveParamsTable.removeReferences();
            this.m_receiveParamsTable = null;
        }
        this.m_receiveParamsTableModel = null;
    }
}

